<?php
session_start();
require_once 'db_connect.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Proses Hapus Cabang
if (isset($_POST['delete_id'])) {
    $id = intval($_POST['delete_id']);
    
    // Cek apakah cabang dipakai di transaksi/user/stok agar tidak error foreign key
    $check = $conn->query("SELECT id FROM users WHERE branch_id = $id UNION SELECT id FROM transactions WHERE branch_id = $id");
    
    if ($check->num_rows > 0) {
        $error_msg = "Gagal menghapus! Cabang ini memiliki data transaksi atau karyawan aktif.";
    } else {
        $stmt = $conn->prepare("DELETE FROM branches WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        header("Location: branches.php");
        exit;
    }
}

$result = $conn->query("SELECT * FROM branches ORDER BY id ASC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Outlet</title>
    <style>
        body { margin: 0; font-family: sans-serif; display: flex; height: 100vh; background-color: #f0f2f5; }
        .sidebar { width: 250px; background-color: #343a40; color: white; display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid #4b545c; font-size: 20px; font-weight: bold; }
        .menu { list-style: none; padding: 0; margin: 0; }
        .menu li { border-bottom: 1px solid #4b545c; }
        .menu a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .menu a:hover, .menu a.active { background-color: #495057; color: white; }
        .content { flex: 1; padding: 20px; overflow-y: auto; }
        .header { background: white; padding: 15px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .btn { padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; font-size: 14px; display: inline-block; }
        .btn-primary { background-color: #007bff; color: white; }
        .btn-danger { background-color: #dc3545; color: white; }
        .btn-logout { background-color: #dc3545; color: white; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; border-bottom: 1px solid #ddd; text-align: left; }
        th { background-color: #f8f9fa; }
        .alert { color: red; margin-bottom: 10px; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-header">Admin Panel</div>
        <ul class="menu">
            <li><a href="index.php">Dashboard</a></li>
            <li><a href="branches.php" class="active">Outlet</a></li> <li><a href="users.php">Karyawan</a></li> <li><a href="products.php">Produk</a></li>
            <li><a href="stocks.php">Stok</a></li>
            <li><a href="transactions.php">Laporan</a></li>
        </ul>
    </div>

    <div class="content">
        <div class="header">
            <h2>Daftar Outlet</h2>
            <a href="logout.php" class="btn btn-logout">Keluar</a>
        </div>
        
        <div class="card">
            <?php if(isset($error_msg)): ?>
                <div class="alert"><?php echo $error_msg; ?></div>
            <?php endif; ?>

            <div style="margin-bottom: 15px;">
                <a href="branch_form.php" class="btn btn-primary">+ Tambah Outlet</a>
            </div>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nama Outlet</th>
                        <th>Alamat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['name']); ?></td>
                                <td><?php echo htmlspecialchars($row['address']); ?></td>
                                <td>
                                    <a href="branch_form.php?id=<?php echo $row['id']; ?>" class="btn btn-primary" style="font-size: 12px;">Edit</a>
                                    <form method="POST" style="display:inline;" onsubmit="return confirm('Yakin ingin menghapus outlet ini?');">
                                        <input type="hidden" name="delete_id" value="<?php echo $row['id']; ?>">
                                        <button type="submit" class="btn btn-danger" style="font-size: 12px;">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;">Belum ada outlet.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>