<?php
session_start();
require_once 'db_connect.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$sql = "SELECT s.id, b.name as branch_name, p.name as product_name, s.qty, s.last_updated 
        FROM stocks s 
        JOIN branches b ON s.branch_id = b.id 
        JOIN products p ON s.product_id = p.id 
        ORDER BY b.name ASC, p.name ASC";

$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Stok</title>
    <style>
        body { margin: 0; font-family: sans-serif; display: flex; height: 100vh; background-color: #f0f2f5; }
        .sidebar { width: 250px; background-color: #343a40; color: white; display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid #4b545c; font-size: 20px; font-weight: bold; }
        .menu { list-style: none; padding: 0; margin: 0; }
        .menu li { border-bottom: 1px solid #4b545c; }
        .menu a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .menu a:hover, .menu a.active { background-color: #495057; color: white; }
        .content { flex: 1; padding: 20px; overflow-y: auto; }
        .header { background: white; padding: 15px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .btn-logout { background-color: #dc3545; color: white; padding: 8px 15px; text-decoration: none; border-radius: 4px; font-size: 14px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; border-bottom: 1px solid #ddd; text-align: left; }
        th { background-color: #f8f9fa; }
        .low-stock { color: red; font-weight: bold; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-header">Admin Panel</div>
        <ul class="menu">
            <li><a href="index.php">Dashboard</a></li>
            <li><a href="branches.php">Outlet</a></li>
            <li><a href="users.php">Karyawan</a></li>
            <li><a href="products.php">Produk</a></li>
            <li><a href="stocks.php" class="active">Stok</a></li>
            <li><a href="transactions.php">Laporan</a></li>
        </ul>
    </div>

    <div class="content">
        <div class="header">
            <h2>Laporan Stok Cabang</h2>
            <a href="logout.php" class="btn-logout">Keluar</a>
        </div>
        
        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th>Cabang</th>
                        <th>Produk</th>
                        <th>Sisa Stok</th>
                        <th>Terakhir Update</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result && $result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['branch_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                <td class="<?php echo ($row['qty'] < 10) ? 'low-stock' : ''; ?>">
                                    <?php echo $row['qty']; ?>
                                </td>
                                <td><?php echo $row['last_updated']; ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;">Belum ada data stok.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>