<?php
session_start();
require_once 'db_connect.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Query untuk mengambil data transaksi
$sql = "SELECT t.id, t.created_at, b.name as branch_name, u.full_name as cashier_name, t.total_amount, t.payment_method, t.offline_id 
        FROM transactions t 
        JOIN branches b ON t.branch_id = b.id 
        JOIN users u ON t.user_id = u.id 
        ORDER BY t.created_at DESC";

$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Transaksi</title>
    <style>
        body { margin: 0; font-family: sans-serif; display: flex; height: 100vh; background-color: #f0f2f5; }
        .sidebar { width: 250px; background-color: #343a40; color: white; display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid #4b545c; font-size: 20px; font-weight: bold; }
        .menu { list-style: none; padding: 0; margin: 0; }
        .menu li { border-bottom: 1px solid #4b545c; }
        .menu a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .menu a:hover, .menu a.active { background-color: #495057; color: white; }
        .content { flex: 1; padding: 20px; overflow-y: auto; }
        .header { background: white; padding: 15px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .btn-logout { background-color: #dc3545; color: white; padding: 8px 15px; text-decoration: none; border-radius: 4px; font-size: 14px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; border-bottom: 1px solid #ddd; text-align: left; font-size: 14px; }
        th { background-color: #f8f9fa; }
        .text-right { text-align: right; }
        .error-msg { color: red; font-weight: bold; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-header">Admin Panel</div>
        <ul class="menu">
            <li><a href="index.php">Dashboard</a></li>
            <li><a href="products.php">Produk</a></li>
            <li><a href="stocks.php">Stok</a></li>
            <li><a href="transactions.php" class="active">Laporan</a></li>
        </ul>
    </div>

    <div class="content">
        <div class="header">
            <h2>Laporan Transaksi</h2>
            <a href="logout.php" class="btn-logout">Keluar</a>
        </div>
        
        <div class="card">
            <?php if (!$result): ?>
                <p class="error-msg">Error Database: <?php echo $conn->error; ?></p>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Waktu</th>
                            <th>Cabang</th>
                            <th>Kasir</th>
                            <th>Metode</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result->num_rows > 0): ?>
                            <?php while($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td>#<?php echo $row['id']; ?></td>
                                    <td><?php echo $row['created_at']; ?></td>
                                    <td><?php echo htmlspecialchars($row['branch_name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['cashier_name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['payment_method']); ?></td>
                                    <td class="text-right">Rp <?php echo number_format($row['total_amount'], 0, ',', '.'); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" style="text-align:center;">Belum ada transaksi yang tercatat.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>

</body>
</html>